
#include "/settings.glsl"

uniform float viewHeight;
uniform float viewWidth;
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform vec3 fogColor;
uniform vec3 skyColor;

#if VANILLA_SUNSETS == 0
	uniform mat4 gbufferModelViewInverse;
	uniform float sunAngle;
	uniform float Foggy=0.;

#endif
#if CLOUDS == 25
	uniform int worldTime;
	//uniform mat4 gbufferProjectionInverse;
	uniform mat4 gbufferModelViewInverse;
	#include "/clouds.glsl"
#endif

varying vec4 starData; //rgb = star color, a = flag for weather or not this pixel is a star.

const float sunPathRotation = 30.0;

float fogify(float x, float w) {
	return w / (x * x + w);
}

vec3 calcSkyColor(vec3 pos) {
	float upDot = dot(pos, gbufferModelView[1].xyz);
	#if VANILLA_SUNSETS == 0
		float hor = (sunAngle<.25? .0 : sunAngle<.75? .5 : 1.);
		float sunset = clamp(1.-abs(sunAngle-hor)*4.,0.,1.);
		sunset*= sunAngle>= .5 ? 1. : sunset;
		bool srise = (sunAngle<.25? true : sunAngle<.75? false : true);
		sunset=  max(0., sunset*(normalize((gbufferModelViewInverse*vec4((pos.xyz), 1.)).xyz-gbufferModelViewInverse[3].xyz)).x * (srise ? 1. : -1.)
			 
		)
		;
		
		vec3 fogColor1 = mix(mix(skyColor,vec3(skyColor.b),.25*Foggy),vec3(1.,.5,0.),sunset);
		return mix(skyColor, fogColor1, fogify(max(upDot, 0.0), 0.25));
	#else
		return mix(skyColor, fogColor, fogify(max(upDot, 0.0), 0.25));
	#endif

	
	
}

void main() {
	vec3 color;
	if (starData.a > 0.5) {
		color = starData.rgb;
	}
	else {
		vec4 pos = vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight) * 2.0 - 1.0, 1.0, 1.0);
		pos = gbufferProjectionInverse * pos;
		#if CLOUDS == 25
			color=clouds(vec2(gl_FragCoord.xy / vec2(viewWidth, viewHeight))).rgb;
		#else
			color = calcSkyColor(normalize(pos.xyz));
		#endif
		
	}

#if FIX_COLOR_SPACE == 1
	//color.rgb=pow(color.rgb,vec3(2.2));
#endif
					
		#if WATER_COL_ABSORB >= 2 
			/* RENDERTARGETS: 5 */
		#else
			/* RENDERTARGETS: 0 */
		#endif
		
	gl_FragData[0] = vec4(color, 1.0); //gcolor
}